# -*- encoding: utf-8 -*-
from SciEngine_API import sciengine_api

token = ""
###若您想处理一个文件，请将文件的内容读取为一个list，然后调用sciengine_api()。
###sciengine_api()共有三个参数。text_list:您想处理的文本内容；api_name:您想调用的api名称，全部api名称见readme.txt；token:若您还没有token，请前往http://sciengine.las.ac.cn/login获取。
###result即为返回的结果，您可根据需要对result进行处理或将result存入文件中。
###以下是一些例子。

# 中文摘要语步识别：move_recognition_cn
# 英文摘要语步识别：move_recognition_en, move_recognition_en_v2 
# 基金项目语步识别:move_recognition_funds
# 中文科研实体识别：api_ner_sci_cn, api_ner_sci_cn_v2
# 英文科研实体识别：api_ner_sci_en, api_ner_sci_en_v2
# 医学领域科技文献命名实体识别:api_ner_med_cn
# 物理学领域科技文献命名实体识别:ner_physics_en
# 中文科技文献关键词识别:keywords_extraction_cn
# 中文科技文本标题生成:title_generation_cn
# 中文科技文献分类:paper_classification_cn 
# 投稿期刊推荐:journal_recommendation_cn
# 审稿人推荐:reviewer_recommendation_cn
# 英文创新句识别innovation_sentence_en
# 英文概念定义句识别:definition_recognition_en
# 英文研究问题句识别:question_recognition_en, question_recognition_en_v2
# 英文研究问题短语识别：question_phrase_en
# 英文引用句识别：citation_recognition_en_v2
# 英文聚类标签生成：cluster_label_en

text_list = ["In modern recommender systems, there are usually comments or reviews from users that justify their ratings for different items. Trained on such textual corpus, explainable recommendation models learn to discover user interests and generate personalized explanations. Though able to provide plausible explanations, existing models tend to generate repeated sentences for different items or empty sentences with insufficient details. This begs an interesting question: can we immerse the models in a multimodal environment to gain proper awareness of real-world concepts and alleviate above shortcomings? To this end, we propose a visually-enhanced approach named METER with the help of visualization generation and text–image matching discrimination: the explainable recommendation model is encouraged to visualize what it refers to while incurring a penalty if the visualization is incongruent with the textual explanation. Experimental results and a manual assessment demonstrate that our approach can improve not only the text quality but also the diversity and explainability of the generated explanations."]

phrase_question_list = ["Detecting Missing Method Calls as Violations;;partial observability to the projective simulation (projective simulation);;a realistic matching approach;;Fast and Robust Rank Aggregation against Model Misspecification;;A Comprehensive Study of Bloated Dependencies", "a quantitative type system;;node representations against perturbations in Recent;;evolution of solvers and data structures", "Event-Triggered Observers for Linear Systems;;the Bayesian hierarchical mixture clustering model"]

text_list_en_longtext = ["Arrhythmogenic right ventricular dysplasia (ARVD) was first recognized in 1977 during antiarrhythmic surgery in Pitié Salpêtrière Hospital, Paris, France [1]. The dysplasia predominantly involved the original “triangle of dysplasia” (Fig.1). The diagnosis of ARVD was pathologically based on previous findings of myocardium embedded in or bordered by fatty tissue and/or fibrosis (Fig.2) [1–4]. Biventricular involvement (Fig.3) is very frequently observed at later stages, leading to congestive heart failure and death [5–10]. Naxos disease is a special form of ARVD, which was first described by Dr. Nikos Protonotarios and colleagues on the island of Naxos, Greece [11] and then in other regions [12–21]. It is an inherited condition with a recessive form of transmission and a familial penetrance of 90% [11, 22–27]. It is associated with thickening of the skin of the hands and sole, and a propensity to woolly hair. The cardiac anomalies characterized by ventricular arrhythmias with ventricular extrasystoles and tachycardia and histologic features of the myocardium are consistent with ARVD, but in a more severe form of dysplasia with major dilatation of the right ventricle [23, 25, 26, 28–30]. The identification of the responsible first gene on chromosome 17, and its product plakoglobin as the responsible protein for Naxos disease proved to be a milestone in the study of ARVD, which opened a new field of research [28, 31]. In this review, we provide an impressive historical overview of events and developments that lead to the appearance of the Naxos disease concept in the context of ARVD. The review provides a first-hand account and bears a great deal of personal touch in description of the important historical events."]

text_list_cn = ["针对心理医学领域文本段落冗长、数据稀疏、知识散乱且规范性差的问题,提出一种基于多层级特征抽取能力预训练模型(MFE-BERT)与前向神经网络注意力机制(FNNAttention)的心理医学知识图谱构建方法. MFE-BERT在BERT模型基础上将其内部所有Encoder层特征进行合并输出,以获取包含更多语义的特征向量,同时对两复合模型采用FNNAttention机制强化词级关系,解决长文本段落语义稀释问题.在自建的心理医学数据集中,设计MFE-BERT-BiLSTM-FNNAttention-CRF和MFE-BERT-CNN-FNNAttention复合神经网络模型分别进行心理医学实体识别和实体关系抽取,实体识别F1值达到93.91%,实体关系抽精确率达到了89.29%,通过融合文本相似度与语义相似度方法进行实体对齐,将所整理的数据存储在Neo4j图数据库中,构建出一个含有3 652个实体, 2 396条关系的心理医学知识图谱.实验结果表明,在MFE-BERT模型与FNNAttention机制的基础上构建心理医学知识图谱切实可行,提出的改进模型所搭建的心理医学知识图谱可以更好地应用于心理医学信息管理中,为心理医学数据分析提供参考."]

text_list_en = ["There has been a framework sketched for learning deep bidirectional intelligence.The framework has an inbound that features two actions: one is the acquiring action, which gets inputs in appropriate patterns, and the other is A-S cognition, derived from the abbreviated form of words abstraction and self-organization, which abstracts input patterns into concepts that are labeled and understood by self-organizing parts involved in the concept into structural hierarchies.The top inner domain accommodates relations and a priori knowledge with the help of the A-I thinking action that is responsible for the accumulation-amalgamation and induction-inspiration.The framework also has an outbound that comes with two actions.One is called I-S reasoning, which makes inference and synthesis (I-S) and is responsible for performing various tasks including image thinking and problem solving, and the other is called the interacting action, which controls, communicates with, and inspects the environment.Based on this framework, we further discuss the possibilities of design intelligence through synthesis reasoning."]

dict_list = [
    {
        "title": "Urinary fluorescent metabolite O-aminohippuric acid is a useful biomarker for lung cancer detection",
        "abstract": "INTRODUCTION Urine contains diagnostically important metabolites that can act as natural fluorophores. However, whether these fluorescent metabolites can be used in lung cancer diagnosis is unknown. OBJECTIVES This study was conducted to determine whether fluorescent urinary metabolites could be useful biomarkers for lung cancer detection. METHODS A total of 46 lung cancer patients and 185 volunteers without cancer were evaluated between November 2013 and November 2014. Samples of the first urine of the day were collected from lung cancer patients and diagnosed at the Hamamatsu University School of Medicine and the Hamamatsu Medical Center prior to cancer treatment, and from volunteers without cancer at the Hamamatsu Medical Imaging Center. Fluorescent urinary metabolites were screened by high-performance liquid chromatography and select effective fluorescent substances for distinguishing cancer from non-cancer status. RESULTS The fraction of patients at each stage of cancer severity were: 41.3% stage I, 8.7% stage II, 19.6% stage III, and 30.4% stage IV. A robust predictive biomarker for lung cancer was selected by the multivariate logistic analysis of fluorescent metabolites and identified to be O-aminohippuric acid (OAH). The area under the curve (AUC) data for OAH was 0.837 (95% CI 0.769-0.898, P < 0.001). CONCLUSION We identified a fluorescent urinary metabolite that can predict lung cancer. OAH exceeds the AUC (0.817) of lung cancer detection by AminoIndex® cancer screening, can be analyzed non-invasively without additional sample processing, and may be a valuable addition to existing lung cancer prediction models.",
        "keywords": "Center prior; lung cancer diagnosis; multivariate logistic analysis; Lung cancer; cancer detection; predictive biomarker; lung cancer patients; stage IV; Biomarker; cancer treatment; area under curve; O-aminohippuric acid; stage II; Urinary fluorescent metabolite; Medical Center; fluorescent metabolites; prediction models"
    }
]

print(sciengine_api(text_list=text_list_en,api_name="move_recognition_en_v2",token=token))
print(sciengine_api(text_list=text_list_en,api_name="question_recognition_en_v2",token=token))
print(sciengine_api(text_list=text_list_cn,api_name="api_ner_sci_cn_v2",token=token))
print(sciengine_api(text_list=text_list_en,api_name="api_ner_sci_en_v2",token=token))
print(sciengine_api(text_list=text_list_en_longtext,api_name="citation_recognition_en_v2",token=token))
print(sciengine_api(text_list=text_list,api_name="innovation_sentence_en",token=token))
print(sciengine_api(text_list=phrase_question_list,api_name="cluster_label_en",token=token))
print(sciengine_api(text_list=dict_list,api_name="question_phrase_en",token=token))