# -*- encoding: utf-8 -*-
from SciEngine_API import sciengine_api
import json

token = ""

###若您想处理一个文件，请将文件的内容读取为一个list，然后调用sciengine_api()。
###sciengine_api()共有三个参数。text_list:您想处理的文本内容；api_name:您想调用的api名称，全部api名称见readme.txt；token:若您还没有token，请前往http://sciengine.las.ac.cn/login获取。
###result即为返回的结果，您可根据需要对result进行处理或将result存入文件中。
###以下是一些例子。

# ========================待处理的文本============================
text_list_cn = [
    "针对心理医学领域文本段落冗长、数据稀疏、知识散乱且规范性差的问题,提出一种基于多层级特征抽取能力预训练模型(MFE-BERT)与前向神经网络注意力机制(FNNAttention)的心理医学知识图谱构建方法. MFE-BERT在BERT模型基础上将其内部所有Encoder层特征进行合并输出,以获取包含更多语义的特征向量,同时对两复合模型采用FNNAttention机制强化词级关系,解决长文本段落语义稀释问题.在自建的心理医学数据集中,设计MFE-BERT-BiLSTM-FNNAttention-CRF和MFE-BERT-CNN-FNNAttention复合神经网络模型分别进行心理医学实体识别和实体关系抽取,实体识别F1值达到93.91%,实体关系抽精确率达到了89.29%,通过融合文本相似度与语义相似度方法进行实体对齐,将所整理的数据存储在Neo4j图数据库中,构建出一个含有3 652个实体, 2 396条关系的心理医学知识图谱.实验结果表明,在MFE-BERT模型与FNNAttention机制的基础上构建心理医学知识图谱切实可行,提出的改进模型所搭建的心理医学知识图谱可以更好地应用于心理医学信息管理中,为心理医学数据分析提供参考."]
text_list = [
    "In modern recommender systems, there are usually comments or reviews from users that justify their ratings for different items. Trained on such textual corpus, explainable recommendation models learn to discover user interests and generate personalized explanations. Though able to provide plausible explanations, existing models tend to generate repeated sentences for different items or empty sentences with insufficient details. This begs an interesting question: can we immerse the models in a multimodal environment to gain proper awareness of real-world concepts and alleviate above shortcomings? To this end, we propose a visually-enhanced approach named METER with the help of visualization generation and text–image matching discrimination: the explainable recommendation model is encouraged to visualize what it refers to while incurring a penalty if the visualization is incongruent with the textual explanation. Experimental results and a manual assessment demonstrate that our approach can improve not only the text quality but also the diversity and explainability of the generated explanations."]
text_list_en = [
    "There has been a framework sketched for learning deep bidirectional intelligence.The framework has an inbound that features two actions: one is the acquiring action, which gets inputs in appropriate patterns, and the other is A-S cognition, derived from the abbreviated form of words abstraction and self-organization, which abstracts input patterns into concepts that are labeled and understood by self-organizing parts involved in the concept into structural hierarchies.The top inner domain accommodates relations and a priori knowledge with the help of the A-I thinking action that is responsible for the accumulation-amalgamation and induction-inspiration.The framework also has an outbound that comes with two actions.One is called I-S reasoning, which makes inference and synthesis (I-S) and is responsible for performing various tasks including image thinking and problem solving, and the other is called the interacting action, which controls, communicates with, and inspects the environment.Based on this framework, we further discuss the possibilities of design intelligence through synthesis reasoning."]
text_list_en_2 = [
    "In this section, we ﬁrst introduce the problem setting of vanilla RA and RA under model misspeciﬁ- cation. Furthermore, we summarize previous robust RA for alleviating the model misspeciﬁcation, as well as their deﬁciencies. Then, we motivate our Coarsened RA, which perform regular RA over a neighborhood of the collected preferences, and therefore enjoys distributional robustness against noise-agnostic perturbation within a neighborhood. 2.1 Rank aggregation In Table 1, we ﬁrst illustrate the common mathematical notations that are used later. 4 Fast and Robust Rank Aggregation against Model Misspecification R 𝐴? denote a collection of partial preferences { 𝜋? 1 , 𝜋? 2 , . . . , 𝜋? 𝐴? } over the item set O = { 𝐴? 1 , 𝐴? 2 , . . . , 𝐴? 𝐴? } R 𝐴? into a consensus order over all 𝐴? items in O (See Figure 1). The consensus order should achieve the maximum agreement among all preferences in R 𝐴? (Dwork et al., 2001). Figure 1: The paradigm of rank aggregation. Particularly, it assumes there exists a preference generative model 𝐴? 𝐴? from which the preferences R 𝐴? are sampled, i.e., R 𝐴? = { 𝜋? 𝐴? | 𝜋? 𝐴? ∼ 𝐴? 𝐴? , 𝐴? = 1 , 2 , . . . , 𝐴? } . However, the real data generation model 𝐴? 𝐴? is hardly accessible due to the complexity of the real situation. For the sake of easier modeling, a parameterized rank model 𝐴? 𝛹? is usually adopted under the assumption of homogeneity of users 1 . Let P be the set of all probability rank models under the homogeneity assumption. For the sake of easier modeling, a parameterized rank model 𝐴? 𝛹? is usually adopted under the assumption of homogeneity of users. Then a maximum likelihood estimation (MLE) for RA can be formulated as follows, max 𝛹? ∈ Θ  𝐴? 𝛹? (R 𝐴? ) , where 𝐴? 𝛹? ∈ P and R 𝐴? = { 𝜋? 𝐴? | 𝜋? 𝐴? ∼ 𝐴? 𝐴? , 𝐴? = 1 , 2 , . . . , 𝐴? } . (1) 𝐴? 𝛹? (R 𝐴? ) =  � 𝐴? 𝐴? = 1  𝐴? 𝛹? ( 𝜋? 𝐴? ) denotes the likelihood over the collected preferences R 𝐴? . 𝐴? 𝛹? is usually instantiated with Thurstone model (Thurstone, 1927a,b), Bradley-Terry model (Bradley and Terry, 1952), Plackett-Luce model (Plackett, 1975; Luce, 1959), etc. Note that the model parameter 𝛹? is usually associated with each item, where the full ranking list could be derived accordingly after 𝛹? is inferred. For example, the full ranking list can be obtained by sorting the model parameter 𝛹? in the case of the Thurstone/Bradley-Terry/Plackett-Luce model. 2.2 Rank aggregation under model misspeciﬁcation here refers to the mismatch between the ranking model 𝐴? 𝛹? and the ranking dataset R 𝐴? , namely the collected user preferences do not strictly satisfy the user homogeneity assumption of the ranking model. homogeneous user community due to the ﬂexible data construction and the complex real situation (See Figure 2). For example, the reliability of each user would not be the same and the single total order assumption would be no longer satisﬁed. Mathematically, we adopt the parameterized ranking model 𝐴? 𝛹? ∈ P under the homogeneity assumption, while the real preference generation distribution 1. Sampling the partial preferences from a speciﬁc probability ranking model is not our focus in this paper. Please refer to Liu et al. (2019); Zhao and Xia (2019) for related literature. 5 Pan, Tsang, Chen, Niu and Sugiyama Figure 2: neighborhood of the collected preferences (See Equation (7) and Equation (8) ). Stage 2: adopting relative entropy as the divergence measure and assign an exponential prior for the size of the neighborhood (See Theorem 2 and Theorem 3). 𝐴? 𝐴? violates this assumption, i.e., 𝐴? 𝐴? ∉ P . Therefore, an MLE for RA under model misspeciﬁcation can be formulated as follows, max 𝛹? ∈ Θ 𝐴? 𝛹? (R 𝐴? ) where 𝐴? 𝛹? ∈ P , 𝐴? 𝐴? ∉ P and R 𝐴? = { 𝜋? 𝐴? | 𝜋? 𝐴? ∼ 𝐴? 𝐴? , 𝐴? = 1 , 2 , . . . , 𝐴? } . (2) For the sake of explanation, let ℜ 𝐴? represent a virtual dataset { 𝜋? 𝐴? | 𝜋? 𝐴? ∼ 𝐴? 𝛹? , 𝐴? = 1 , 2 , . . . , 𝐴? } , which consists of idealized preferences and satisﬁes the homogeneity assumption. Then, RA under model misspeciﬁcation can be formulated as noisy RA, where the collected preferences are viewed as a noisy perturbation of some idealized preferences. Then, we come to robust rank aggregation against model misspeciﬁcation, namely how to achieve a reliable total order from the collected preferences R 𝐴? using a misspeciﬁed ranking model 𝐴? 𝛹? . 2.3 Previous attempts: convolving ranking model with certain perturbation mechanisms could be 𝐴? 𝛹? ( 𝜋? 𝐴? ) = ∑︁ 𝜋? 𝐴? 𝐴? 𝛹? ( 𝜋? 𝐴? ) 𝐴? ( 𝜋? 𝐴? | 𝜋? 𝐴? ) = ∑︁ 𝜋? 𝐴? 𝐴? ( 𝜋? 𝐴? , 𝜋? 𝐴? ) , where 𝜋? 𝐴? ∼ 𝐴? 𝐴? , 𝜋? 𝐴? ∼ 𝐴? 𝛹? . (3) 𝐴? 𝐴? and 𝐴? 𝛹? as well as the conditional distribution 𝐴? ( 𝜋? 𝐴? | 𝜋? 𝐴? ) and joint distribution 𝐴? ( 𝜋? 𝐴? , 𝜋? 𝐴? ) should all be the discrete distribution. additional error/noise/uncertainty caused misspeciﬁcation. For the sake of tractability, the perturbation mechanism is usually deﬁned at the sample level. According to Equation (3) , there are essentially two ways of implementing this: • distribution, i.e., 𝐴? ( 𝜋? 𝐴? | 𝜋? 𝐴? ) distribution 𝐴? 𝛹? with the predeﬁned perturbation, leading to a new model that has a few more parameters but is just as bound to be misspeciﬁed w.r.t. other overlooked perturbations. 6 Fast and Robust Rank Aggregation against Model Misspecification • The second approach would be to model the joint distribution 𝐴? ( 𝜋? 𝐴? , 𝜋? 𝐴? ) directly, which needs to take into consideration all potential perturbations. Essentially, it needs to be a nonparametric model for 𝐴? ( 𝜋? 𝐴? , 𝜋? 𝐴? ) , but would easily be computationally intractable. setting. It is impossible to design a universal practice that can be generalized to most settings. perspective. 2.4 Our CoarsenRank: rank aggregation over the neighborhood of ranking data intended to address. We are concerned with robust rank aggregation against model misspeciﬁcation (Equation (2) ) in general, not just one particular kind of perturbation considered in previous work. the Coarsening mechanism, namely inferring over the neighborhood of the original dataset would equip the learning model with distributional robustness mechanism, we consider performing rank aggregation over the neighborhood of the ranking data. To deliver our model, we ﬁrst give the deﬁnition of the neighborhood in the sense of ranking data as follows, Deﬁnition 1 (sample-level neighborhood) Let R 𝐴? denote the ranking dataset and 𝜋? represent one preference belonging to R 𝐴? 𝐴? 𝐴? (R 𝐴? , 𝜋? ) of the R 𝐴? with size 𝜋? > 0 as follows: 𝐴? 𝐴? (R 𝐴? , 𝜋? ) = { 𝜋? ′ | 𝐴? ( 𝜋? ′ , 𝜋? ) < 𝜋?, ∃ 𝜋? ∈ R 𝐴? } , (4) where 𝐴? (· , ·) denotes some distance measure between two preferences 𝜋? ′  and 𝜋? , e.g., Kendall tau distance (Kendall, 1938), Spearman’s rank correlation (Daniel, 1990). Deﬁnition 2 (distribution-level neighborhood) Let R 𝐴? denote the ranking dataset and 𝐴? 𝐴? (R 𝐴? , 𝜋? ) denote the neighborhood of the ranking dataset R 𝐴? with size 𝜋? > 0 . Then, we deﬁne 𝐴? 𝐴? (R 𝐴? , 𝜋? ) = {R ′ 𝐴?  | 𝐴? (R ′ 𝐴?  , R 𝐴? ) < 𝜋? } , (5) where 𝐴? (· , ·) denotes some distance measures between two ranking datasets. The distance measure between two datasets is usually deﬁned as the divergence of their corresponding empirical distributions. Popular divergence measures between distributions are Kullback-Leibler (KL) divergence (Kullback and Leibler, 1951), 𝐴? -divergence (Ali and Silvey, 1966) and Wasserstein metric (Villani, 2008). Proposition 1 Given any ranking dataset R 𝐴? , R 𝐴? must be (1) a subset of its sample-level neighbor- hood 𝐴? 𝐴? (R 𝐴? , 𝜋? ) if 𝐴? (· , ·) is deﬁned between two preferences, or (2) an element of its distribution-level neighborhood 𝐴? 𝐴? (R 𝐴? , 𝜋? ) if 𝐴? (· , ·) is deﬁned between two ranking datasets. Namely R 𝐴? ⊆ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) , sample-level neighborhood, R 𝐴? ∈ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) , distribution-level neighborhood. 7 Pan, Tsang, Chen, Niu and Sugiyama Proof: In terms of sample-level neighborhood, we have ∀ 𝜋? ∈ R 𝐴? , ∃ 𝜋? ∗  = 𝜋?, s.t. 𝐴? ( 𝜋? ∗ , 𝜋? ) = 0 < 𝜋?. 𝜋? ∈ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) holds. Accordingly, R 𝐴? ⊆ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) holds according to the deﬁnition of sample-level neighborhood in Equation (4). In terms of distribution-level neighborhood, we have 𝐴? (R 𝐴? , R 𝐴? ) = 0 < 𝜋?. Therefore, we have R 𝐴? ∈ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) hold according to the deﬁnition of distribution-level neighbor- hood in Equation (5). Note that the proof is valid for any particular choice of the distance metric, either sample level or distribution level. Deﬁnition 3 (empirical data distribution) 𝐴? 𝐴? ( 𝐴? |R 𝐴? ) and 𝐴? 𝐴? ( 𝐴? |ℜ 𝐴? ) denote the empirical distributions of the ranking datasets R 𝐴? and ℜ 𝐴? , respectively. 𝐴? 𝐴? ( 𝐴? |R 𝐴? ) =  1 𝐴? 𝐴? ∑︁ 𝐴? = 1 I 𝜋? 𝐴? ( 𝐴? ) , where I 𝜋? 𝐴? ( 𝐴? ) = � 1 , 𝐴? = 𝜋? 𝐴? 0 , 𝐴? ≠ 𝜋? 𝐴?  , 𝐴? 𝐴? ( 𝐴? |ℜ 𝐴? ) =  1 𝐴? 𝐴? ∑︁ 𝐴? = 1 I 𝜋? 𝐴? ( 𝐴? ) , where I 𝜋? 𝐴? ( 𝐴? ) = � 1 , 𝐴? = 𝜋? 𝐴? 0 , 𝐴? ≠ 𝜋? 𝐴? . (6) generation distribution, namely 𝐴? 𝐴? ( 𝐴? |R 𝐴? ) → 𝐴? 𝐴? and 𝐴? 𝐴? ( 𝐴? |ℜ 𝐴? ) → 𝐴? 𝛹? when 𝐴? → +∞ . neighborhood. Let ℜ 𝐴? ∼ 𝐴? 𝛹? denote every preference of the ranking dataset ℜ 𝐴? is sampled from the ranking distribution 𝐴? 𝛹? , namely ∀ 𝜋? 𝐴? ∈ ℜ 𝐴? , 𝜋? 𝐴? ∼ 𝐴? 𝛹? the idealized ranking dataset ℜ 𝐴? locates in the small neighborhood of the actually collected preferences R 𝐴? , i.e., ∃ a small 𝜋?, ∀ℜ 𝐴? ∼ 𝐴? 𝛹? , we have ℜ 𝐴? ∈ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) 𝜋? which satisﬁes our assumption is very large, it means a completely wrong model is adopted and it is impossible to learn a meaningful result. This is why we call our setting “mild model misspeciﬁcation”. Meanwhile, the sense of “neighborhood” in the distribution level covers most types of noise perturbations (Chen and Paschalidis, 2018a). Therefore, the MLE of our Coarsened rank aggregation (CoarsenRank) can be formulated as follows, max 𝛹? ∈ Θ  𝐴? 𝛹? (ℜ 𝐴? ) , where ℜ 𝐴? ∼ 𝐴? 𝛹? and ℜ 𝐴? ∈ 𝐴? 𝐴? (R 𝐴? , 𝜋? ) . (7) distributional robustness by inferring over the neighborhood of the dataset (Miller and Dunson, 2019). 8 Fast and Robust Rank Aggregation against Model Misspecification (7) ) can be derived as follows Equation (7) 1 ⇐⇒ max 𝛹? ∈ Θ  E ℜ 𝐴? ∼ 𝐴? 𝛹? P (ℜ 𝐴? | 𝛹?, 𝐴? (R 𝐴? , ℜ 𝐴? ) < 𝜋? ) 2 = ⇒ max 𝛹? ∈ Θ  E ℜ 𝐴? ∼ 𝐴? 𝛹? P ( 𝛹? | 𝐴? (R 𝐴? , ℜ 𝐴? ) < 𝜋? ) , (8) where 1 is an equivalent MLE formulation rearranged according to the deﬁnition of distribution-level neighborhood (Equation (5) ). By assigning a suitable prior for model parameter 𝛹? , i.e., 𝛹? ∼ 𝜋 ( 𝛹? ) , 2 deduces the maximum a posteriori probability (MAP) estimate of our CoarsenRank model. (8) reveals that: (1) our CoarsenRank degenerates to vanilla rank aggregation method (Equation (1) ) when the collected preferences satisfy the homogeneity assumption; (2) our Coarsen- in the neighborhood of the collected preferences when model misspeciﬁcation arises; and (3) our CoarsenRank would fail to output a reliable total ranking list when the collected preferences signiﬁcantly violate the homogeneity assumption. The same is true for other vanilla rank aggregation methods and most of robust RAs which fail to capture this perturbation. Therefore, compared with the previous methods, our CoarsenRank is robust to most potential perturbations within a neighborhood, not only to some pre-assumed perturbations. Remark 1 (Coarsening mechanism VS. Minimax distributional robustness) The Coarsening mech- anism max 𝛹? ∈ Θ E ℜ 𝐴? ∈ 𝐴? 𝐴? (R 𝐴? ,𝜋? ) 𝐴? 𝛹? (ℜ 𝐴? ) shares a similar formula with the minimax distributional robustness min 𝛹? ∈ Θ max ℜ 𝐴? ∈ 𝐴? 𝐴? (R 𝐴? ,𝜋? ) ℓ (ℜ 𝐴? | 𝛹? ) (Sinha et al., 2017). ℓ ( 𝛹? ) denotes the loss function, which is usually replaced with the negative log-likelihood. The Coarsening mechanism aims to maximize the likelihood over the neighborhood of original dataset R 𝐴? . The minimax distributional robustness aims to minimize the loss using the worst data samples in the neighborhood of original dataset R 𝐴? level (Equation (5) ) where a Bayesian criterion can be adopted to estimate the proper size of the neighborhood for each dataset; while the neighborhood in the minimax distributional robustness is usually deﬁned at the sample-level (Equation (5) ) and a ﬁxed size neighborhood is adopted once for all. The choice of distance measures 𝐴? (· , ·) inﬂuences robustness guarantee and tractability in the both two paradigms. Remark 2 (Coarsening mechanism VS. Rank-dependent coarsening) The word Coarsening also rises in Fahandar et al. (2017), which, however, has a totally diﬀerent meaning there. The term “rank-dependent coarsening” refers to the process of turning a full ranking into an incomplete one (Fahandar et al., 2017). It is diﬀerent from our “Coarsening mechanism”, which refers to the paradigm that performing the Bayesian inference over the neighborhood of the original dataset."]
text_list_en_3 = [
    "The present investigation was a cross-sectional study based on secondary analyses of data from the weighted fifth Korea National Health and Nutrition Examination Survey (KNHANES V), which was conducted from 2010 to 2012.The KNHANES has been performed since 1998 by the Korea Centers for Disease Control and Prevention (KCDC) for the evaluation of the health and nutritional statuses of Koreans. The KNHANES is a nationally representative, reliable, large-scale, cross-sectional survey targeting non-institutionalized Koreans. Sampling was conducted using a stratified, multi-staged, clustered probability design to ensure a nationally representative sample [34]. Furthermore, the KNHANES V adopted a survey sampling method that avoids duplication of the entire sample for large-scale sample surveys nationwide; therefore, the sample for every survey year was a probability sample representing the entire nation, and each sample has independent and homogenous characteristics. "]
dict_list = [
    {
        "title": "Urinary fluorescent metabolite O-aminohippuric acid is a useful biomarker for lung cancer detection",
        "abstract": "INTRODUCTION Urine contains diagnostically important metabolites that can act as natural fluorophores. However, whether these fluorescent metabolites can be used in lung cancer diagnosis is unknown. OBJECTIVES This study was conducted to determine whether fluorescent urinary metabolites could be useful biomarkers for lung cancer detection. METHODS A total of 46 lung cancer patients and 185 volunteers without cancer were evaluated between November 2013 and November 2014. Samples of the first urine of the day were collected from lung cancer patients and diagnosed at the Hamamatsu University School of Medicine and the Hamamatsu Medical Center prior to cancer treatment, and from volunteers without cancer at the Hamamatsu Medical Imaging Center. Fluorescent urinary metabolites were screened by high-performance liquid chromatography and select effective fluorescent substances for distinguishing cancer from non-cancer status. RESULTS The fraction of patients at each stage of cancer severity were: 41.3% stage I, 8.7% stage II, 19.6% stage III, and 30.4% stage IV. A robust predictive biomarker for lung cancer was selected by the multivariate logistic analysis of fluorescent metabolites and identified to be O-aminohippuric acid (OAH). The area under the curve (AUC) data for OAH was 0.837 (95% CI 0.769-0.898, P < 0.001). CONCLUSION We identified a fluorescent urinary metabolite that can predict lung cancer. OAH exceeds the AUC (0.817) of lung cancer detection by AminoIndex® cancer screening, can be analyzed non-invasively without additional sample processing, and may be a valuable addition to existing lung cancer prediction models.",
        "keywords": "Center prior; lung cancer diagnosis; multivariate logistic analysis; Lung cancer; cancer detection; predictive biomarker; lung cancer patients; stage IV; Biomarker; cancer treatment; area under curve; O-aminohippuric acid; stage II; Urinary fluorescent metabolite; Medical Center; fluorescent metabolites; prediction models"
    }]
phrase_question_list = [
    "Detecting Missing Method Calls as Violations;;partial observability to the projective simulation (projective simulation);;a realistic matching approach;;Fast and Robust Rank Aggregation against Model Misspecification;;A Comprehensive Study of Bloated Dependencies",
    "a quantitative type system;;node representations against perturbations in Recent;;evolution of solvers and data structures",
    "Event-Triggered Observers for Linear Systems;;the Bayesian hierarchical mixture clustering model"]
# 医学
text_list_med = ["The 2019 coronavirus disease (COVID-19) was first identified in Wuhan, Hubei, China in December 2019, caused by a novel coronavirus (SARS-CoV-2). There is a need to study the clinical features of patients in a hospital near Wuhan. To identify clinical features of patients with COVID-19 in a tertiary hospital near Wuhan. General information, clinical manifestations, laboratory data, and computed tomography (CT) data were collected for 225 patients diagnosed of COVID-19 admitted between January 20 and February 14, 2020, to the Hanchuan City People's Hospital. The patients included 120 male and 105 females who had no connection to the Wuhan Huanan Seafood Market. Their average age was 50 ± 14 years. The major clinical symptoms were fever (84.44% of patients), cough (56.44% of patients), and dyspnea (4.00% of patients); 3.56%-22.67% of subjects suffered from expectoration, fatigue, chills, headache, chest pain, and pharyngalgia. Hypertension was present in 20.89% of patients. The counts of white blood cells (WBCs) and lymphocytes were normal or decreased in 86.67% and 99.11% of patients. CRP was increased in 86.22% of patients, PCT in 10.67%, and ESR in 90.22%. CT showed that 86.22% of patients had multiple patchy glassy shadows in both lungs, particularly in the peripheral area. Thirty-seven (16.44%) patients were diagnosed with severe COVID-19. Methylprednisolone was administered in 44.44% of cases. The mortality among the patients was 0.89%. Clinical characteristics of COVID-19 patients in the tertiary hospital near Wuhan are very similar to those found in Wuhan, but the lower mortality."]
# 农业
text_list_arg = ["Tomato plants, Lycopersicon esculentum L. cv. Tmknvf2, and watermelon plants, Citrullus lanatus [Thomb.] Mansf. cv. Dulce maravilla, were grown for 30 days at different temperatures (15, 25 and 35°C). We analysed soluble phenolics, enzymatic activities (phenylalanine ammonia-lyase, polyphenol oxidase and peroxidase), and dry weight. The impact of the three temperatures was different in tomato and watermelon. Our results indicate that heat stress in tomato plants occurred at 35°C, while chilling stress occurred in watermelon plants at 15°C. Thermal stress in both plants caused: (1) decreased shoot weight; (2) accumulation of soluble phenolics; (3) highest phenylalanine ammonia-lyase activity; and (4) lowest peroxidase and polyphenol oxidase activity. These results indicate that thermal stress induces the accumulation of phenolics in the plant by activating their biosynthesis as well as inhibiting their oxidation. This could be considered an acclimation mechanism of the plant against thermal stress."]
# 资源环境
text_list_res = ["Proline and quaternary ammonium compounds (QAC), in addition to being N-rich, are known to accumulate in plants under different environmental stress conditions. The accumulation of N-rich compounds in plants has been shown to confer stress resistance. The aim of our work is two-fold: first, to study the influence of temperature on proline, QAC, and choline metabolism in tomato leaves; and second, to investigate the relationship between N source applied (NO3- or NH4+) and thermal stress resistance in these plants. To do this, experiments were conducted at three different temperatures (10 degrees C, 25 degrees C, 35 degrees C); at each temperature half of the plants received NO3-, and the other half received NH4+. At 35 degrees C the plants had the lowest biomass production with respect to 25 degrees C (optimal temperature) and 10 degrees C (cold stress), suggesting that tomato plants were most affected by heat stress. At 35 degrees C, there were also high levels of choline and proline due to the activation of Delta1-pyrroline-5-carboxylate synthetase (P5CS) and ornithine aminotransferase (OAT), and simultaneous inhibition of proline dehydrogenase (PDH) and proline oxidase (PO). However, plants with NH4+ as the N source exhibited reduced growth with respect to the plants fed with NO3-. This is interesting because, under heat stress (35 degrees C), biomass production, as well as proline and choline accumulation, in NH4+ fed plants was higher than in NO3- fed plants. From this, we concluded that tomato plants fed with NH4+ as the N source show higher tolerance to heat stress (35 degrees C) than plants fed with NO3-."]
# 工业
text_list_ind = ["波音737NG飞机的发动机EEC工作方式分为正常和备用两种，备用方式又分为软备用（soft alternate）和硬备用（hard alternate）两种。波音公司提供的技术资料包含了触发EEC软、硬备用两种方式的工作条件以及对发动机推力的影响，但不包含备用方式的工作原理和依据。本文将利用气体状态参数和气体理想绝能滞止状态的计算公式，对软、硬备用方式的工作原理进行分析和说明，帮助相关工作人员（飞行员、维修人员）更好地理解EEC工作方式，提升安全运行水平。"]

# ========================各类API接口的输出结果========================

# 中文科研实体识别：api_ner_sci_cn_v2
print("api_ner_sci_cn_v2:", sciengine_api(text_list=text_list_cn,api_name="api_ner_sci_cn_v2",token=token))
# 中文科技文献关键词识别:keywords_extraction_cn
print("keywords_extraction_cn",sciengine_api(text_list=text_list_cn,api_name="keywords_extraction_cn",token=token))
# 中文摘要语步识别：move_recognition_cn
print("move_recognition_cn", sciengine_api(text_list=text_list_cn, api_name="move_recognition_cn", token=token))
# 基金项目语步识别:move_recognition_funds
print("move_recognition_funds",sciengine_api(text_list=text_list_cn,api_name="move_recognition_funds",token=token))
# 中文科技文献分类:paper_classification_cn
print("paper_classification_cn",sciengine_api(text_list=text_list_cn,api_name="paper_classification_cn",token=token))
# 英文摘要语步识别：move_recognition_en, move_recognition_en_v2
print("move_recognition_en_v2:", sciengine_api(text_list=text_list_en,api_name="move_recognition_en_v2",token=token))
# 英文研究问题句识别:question_recognition_en, question_recognition_en_v2
print("question_recognition_en_v2:", sciengine_api(text_list=text_list_en,api_name="question_recognition_en_v2",token=token))
# 英文科研实体识别：api_ner_sci_en, api_ner_sci_en_v2
print("api_ner_sci_en_v2:", sciengine_api(text_list=text_list_en,api_name="api_ner_sci_en_v2",token=token))
# 英文引用句识别
print("citation_recognition_en_v2:", sciengine_api(text_list=text_list_en_2,api_name="citation_recognition_en_v2",token=token))
# 英文创新句识别innovation_sentence_en, innovation_sentence_en_v2
print("innovation_sentence_en_v2:", sciengine_api(text_list=text_list,api_name="innovation_sentence_en_v2",token=token))
# 英文聚类标签生成：cluster_label_en
print("cluster_label_en:", sciengine_api(text_list=phrase_question_list,api_name="cluster_label_en",token=token))
# 英文研究问题短语识别：question_phrase_en
print("question_phrase_en:", sciengine_api(text_list=dict_list,api_name="question_phrase_en",token=token))
# 英文概念定义句识别:definition_recognition_en, definition_recognition_en_v2
print("definition_recognition_en_v2:", sciengine_api(text_list=text_list_en_3,api_name="definition_recognition_en_v2",token=token))
# 医学
print("api_medicine_domain_en", sciengine_api(text_list=text_list_med,api_name="api_medicine_domain_en",token=token))
# 农业
print("api_agriculture_domain_en", sciengine_api(text_list=text_list_arg,api_name="api_agriculture_domain_en",token=token))
# 资源环境
print("api_resource_domain_en", sciengine_api(text_list=text_list_res,api_name="api_resource_domain_en",token=token))
# 工业
print("api_industry_domain_cn", sciengine_api(text_list=text_list_ind,api_name="api_industry_domain_cn",token=token))


# PDF解析
pdf_path = "your_pdf_name.pdf"
with open(pdf_path, 'rb') as pdf_file:
    result = sciengine_api(text_list=pdf_file, api_name="pdf_parser_en_v2", token=token)
with open("" + "pdf2json_result" + ".json", "w", encoding="utf-8") as fp:
    fp.write(json.dumps(result, ensure_ascii=False))
