# -*- encoding: utf-8 -*-
import os
import sys
import requests
import json
import base64

os.chdir(sys.path[0])

# API 服务器基础 URL
BASE_URL = 'https://sciengine.las.ac.cn/'

# 🔐 强制不使用代理
NO_PROXY = {"http": None, "https": None}

# ---------------------------
# 工具函数：递归 base64 编码
# ---------------------------
def encode_item(item):
    if isinstance(item, str):
        return base64.b64encode(item.encode()).decode()
    elif isinstance(item, list):
        return [encode_item(i) for i in item]
    elif isinstance(item, dict):
        return {k: encode_item(v) for k, v in item.items()}
    return item

# ---------------------------
# 构建请求负载
# ---------------------------
def build_payload(api_name, text_list, token):
    if api_name in ['title_generation_cn']:
        return {"data": [encode_item(item) for item in text_list], "token": token, "length": 0}, 'form'
    # elif api_name in ['move_recognition_scores_cn', 'move_recognition_scores']:
    #     return {"abstract": encode_item(text_list[0]), "token": token}, 'form'
    elif api_name in ['question_phrase_en', 'article_enrichment_en', 'synthesis_en']:
        return {"data": [encode_item(item) for item in text_list], "token": token}, 'json'
    elif api_name in ['pdf_parser_en', 'pdf_parser_en_v2']:
        file_part = text_list if isinstance(text_list, bytes) else encode_item(text_list)
        metadata = {"token": token}
        files = {
            'file': file_part,
            'json': ('', json.dumps(metadata), 'application/json')
        }
        return files, 'file'
    else:
        return {"data": [encode_item(item) for item in text_list], "token": token}, 'form'

# ---------------------------
# 发送请求（强制不走代理）
# ---------------------------
def send_request(url, payload, mode):
    try:
        if mode == 'form':
            return requests.post(url, data=payload, proxies=NO_PROXY)
        elif mode == 'json':
            return requests.post(url, json=payload, proxies=NO_PROXY)
        elif mode == 'file':
            return requests.post(url, files=payload, proxies=NO_PROXY)
        else:
            raise ValueError("未知请求类型")
    except Exception as e:
        print(f"[请求错误] 请求发送失败：{e}")
        return None

# ---------------------------
# 解析响应
# ---------------------------
def parse_response(api_name, response):
    if response is None:
        return None
    if response.status_code != 200:
        print(f"[请求失败] 状态码: {response.status_code}")
        print(response.text)
        return None
    try:
        # 不同API的返回格式略有不同
        if api_name in ['api_ner_sci_cn', 'api_ner_med_cn', 'api_relation_sci_cn', 'pdf_parser_en', 'pdf_parser_en_v2']:
            return json.loads(response.text)
        elif api_name in ['question_recognition_en', 'definition_recognition_en', 'definition_recognition_en_v2']:
            return eval(response.text.replace("'", '"'))
        else:
            return eval(response.text)
    except Exception as e:
        print(f"[解析错误] 无法解析响应：{e}")
        return None

# ---------------------------
# 公开接口：供外部调用
# ---------------------------
def sciengine_api(text_list, api_name, token):
    url = BASE_URL + api_name
    payload, mode = build_payload(api_name, text_list, token)
    response = send_request(url, payload, mode)
    return parse_response(api_name, response)
